/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.deco.DecoBoulder;
import rtg.api.world.deco.DecoFallenTree;
import rtg.api.world.deco.DecoJungleCacti;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.GroundEffect;
import rtg.api.world.terrain.heighteffect.HeightEffect;
import rtg.api.world.terrain.heighteffect.HeightVariation;
import rtg.api.world.terrain.heighteffect.RaiseEffect;
import rtg.api.world.terrain.heighteffect.VariableRuggednessEffect;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;

public class RealisticBiomeBOPLushDesert
extends RealisticBiomeBOPBase {
    public static Biome biome = (Biome)BOPBiomes.lush_desert.orNull();
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeBOPLushDesert() {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
        this.getConfig().addProperty(this.getConfig().ALLOW_CACTUS).set(true);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPLushDesert(65.0f, 40.0f, 10.0f);
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPLushDesert(this.getConfig(), RealisticBiomeBOPLushDesert.biome.field_76752_A, RealisticBiomeBOPLushDesert.biome.field_76753_B, Blocks.field_150349_c.func_176223_P(), RealisticBiomeBOPLushDesert.biome.field_76753_B, 40.0f, 0.5f, 10.0f, 0.5f);
    }

    @Override
    public void initDecos() {
        DecoBoulder decoBoulder = new DecoBoulder();
        decoBoulder.setBoulderBlock(Blocks.field_150347_e.func_176223_P());
        decoBoulder.setMaxY(80);
        decoBoulder.setChance(16);
        decoBoulder.setStrengthFactor(1.0f);
        this.addDeco(decoBoulder);
        DecoFallenTree decoFallenTree = new DecoFallenTree();
        decoFallenTree.getDistribution().setNoiseDivisor(80.0f);
        decoFallenTree.getDistribution().setNoiseFactor(60.0f);
        decoFallenTree.getDistribution().setNoiseAddend(-15.0f);
        decoFallenTree.setLogConditionChance(12);
        decoFallenTree.setRandomLogBlocks(new IBlockState[]{Blocks.field_150363_s.func_176203_a(1), BOPBlocks.log_3.func_176203_a(2), Blocks.field_150364_r.func_176223_P()});
        decoFallenTree.setMinSize(3);
        decoFallenTree.setMaxSize(5);
        this.addDeco(decoFallenTree, this.getConfig().ALLOW_LOGS.get());
        DecoJungleCacti decoJungleCacti = new DecoJungleCacti();
        decoJungleCacti.setStrengthFactor(8.0f);
        decoJungleCacti.setMaxY(110);
        this.addDeco(decoJungleCacti, this.getConfig().ALLOW_CACTUS.get());
    }

    public static class SurfaceBOPLushDesert
    extends SurfaceBase {
        private IBlockState blockMixTop;
        private IBlockState blockMixFiller;
        private float floMixWidth;
        private float floMixHeight;
        private float floSmallWidth;
        private float floSmallStrength;

        public SurfaceBOPLushDesert(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixTop, IBlockState mixFiller, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
            super(config, top, filler);
            this.blockMixTop = mixTop;
            this.blockMixFiller = mixFiller;
            this.floMixWidth = mixWidth;
            this.floMixHeight = mixHeight;
            this.floSmallWidth = smallWidth;
            this.floSmallStrength = smallStrength;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 3.4f;
            boolean mix = false;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.floMixWidth, (float)j / this.floMixWidth) + simplex.noise2f((float)i / this.floSmallWidth, (float)j / this.floSmallWidth) * this.floSmallStrength > this.floMixHeight) {
                        primer.func_177855_a(x, k, z, this.blockMixTop);
                        mix = true;
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                if (mix) {
                    primer.func_177855_a(x, k, z, this.blockMixFiller);
                    continue;
                }
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPLushDesert
    extends TerrainBase {
        private float minHeight;
        private float mesaWavelength;
        private float hillStrength;
        private float topBumpinessHeight = 2.0f;
        private float topBumpinessWavelength = 15.0f;
        private HeightEffect height;
        private HeightEffect groundEffect;

        public TerrainBOPLushDesert(float minHeight, float maxHeight, float hillStrength) {
            this.minHeight = minHeight;
            this.mesaWavelength = maxHeight;
            this.hillStrength = hillStrength;
            this.groundEffect = new GroundEffect(3.0f);
            HeightVariation topVariation = new HeightVariation();
            topVariation.height = hillStrength;
            topVariation.octave = 1;
            topVariation.wavelength = VariableRuggednessEffect.STANDARD_RUGGEDNESS_WAVELENGTH;
            HeightVariation topBumpiness = new HeightVariation();
            topBumpiness.height = this.topBumpinessHeight;
            topBumpiness.wavelength = this.topBumpinessWavelength;
            topBumpiness.octave = 3;
            this.height = new VariableRuggednessEffect(new RaiseEffect(0.0f), topVariation.plus(topBumpiness).plus(new RaiseEffect(hillStrength)), 0.3f, 0.15f, this.mesaWavelength);
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPLushDesert.riverized(this.minHeight + this.groundEffect.added(rtgWorld, x, y), river) + this.height.added(rtgWorld, x, y);
        }
    }
}

